import numpy as np
import matplotlib.pyplot as plt

# Lecture du fichier en sautant la première ligne
data = np.loadtxt("geiger_datatempsmortmicro17.txt", skiprows=1)

# Calcul des intervalles en µs (pas de division par 1000)
delta_t = np.diff(data)

# Tracé de l'histogramme des intervalles
plt.hist(delta_t, bins='auto', edgecolor='black')
plt.xlabel("Intervalle de temps entre événements (µs)")
plt.ylabel("Occurrence")
plt.title("Histogramme des intervalles de temps (ti+1 - ti)")
#plt.yscale("log")  # permet de mieux voir la distribution
plt.grid(True)
#plt.xlim(0,1000)
#plt.ylim(0,1000)


#plt.xticks(np.arange(0, 54, 2))  # ticks tous les 4 µs jusqu’à 200

plt.show()


